/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.aikar.commands.ACFVelocityUtil;
import net.skinsrestorer.shadow.aikar.commands.CommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandManager;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public class VelocityCommandIssuer
implements CommandIssuer {
    private final VelocityCommandManager manager;
    private final CommandSource source;

    VelocityCommandIssuer(VelocityCommandManager manager, CommandSource source) {
        this.manager = manager;
        this.source = source;
    }

    public CommandSource getIssuer() {
        return this.source;
    }

    public Player getPlayer() {
        return this.isPlayer() ? (Player)this.source : null;
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public boolean isPlayer() {
        return this.source instanceof Player;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        if (this.isPlayer()) {
            return ((Player)this.source).getUniqueId();
        }
        return UUID.randomUUID();
    }

    @Override
    public void sendMessageInternal(String message) {
        this.source.sendMessage((Component)ACFVelocityUtil.color(message));
    }

    @Override
    public boolean hasPermission(String name) {
        return this.source.hasPermission(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VelocityCommandIssuer that = (VelocityCommandIssuer)o;
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }
}

